/* USBAbsMouse.h */
/* USB device example: Mouse with absolute positioning */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _ABSOLUTE_MOUSE_
#define _ABSOLUTE_MOUSE_

#include "GenericMouse.h"
#include "USBHID.h"

/** USB device: an absolute mouse
 *
 * Warning: you can only instantiate one instance of a USB device: USBMouse, USBKeyboard, USBAbsMouse, USBMouseKeyboard, or USBAbsMouseKeyboard.
 *
 * Example:
 * @code
 *
 * #include "mbed.h"
 * #include "USBAbsMouse.h"
 *
 * USBAbsMouse mouse;
 *
 * #define STEP (20)
 *
 * int main(void)
 * {
 *   int32_t a = X_MIN;
 *   int32_t dir = STEP;
 *
 *   while (1)
 *   {
 *       mouse.move(a, a);
 *
 *       if (((a+dir) > X_MAX) || ((a+dir) < X_MIN))
 *       {
 *           // Change direction
 *           dir = -dir;
 *       }
 *
 *       a += dir;
 *   }
 * }
 *
 * @endcode
 */
class USBAbsMouse: public GenericMouse, public USBHID
{
    public:
        /**
        *   Constructor for a USBAbsMouse (an absolute mouse)
        */
        USBAbsMouse(){};
        
        /**
        * Write a state of the mouse
        *
        * @param x x absolute position
        * @param y y absolute position
        * @param buttons buttons state (first bit represents MOUSE_LEFT, second bit MOUSE_RIGHT and third bit MOUSE_MIDDLE)
        * @param z wheel state (>0 to scroll down, <0 to scroll up)
        * @return true if there is no error, false otherwise
        */
        virtual bool update(int16_t x, int16_t y, uint8_t buttons, int8_t z);
        
        virtual uint8_t * ReportDesc();
        
        
        
};

#endif
