/* USBBusInterface.h */
/* USB Bus Interface */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_BUS_INTERFACE_
#define _USB_BUS_INTERFACE_

#include "mbed.h"
#include "USBEndpoints.h"

/* Configuration */
bool USBBusInterface_init(void);
void USBBusInterface_uninit(void);
void USBBusInterface_connect(void);
void USBBusInterface_disconnect(void);
void USBBusInterface_configureDevice(void);
void USBBusInterface_unconfigureDevice(void);
void USBBusInterface_setAddress(uint8_t address);
void USBBusInterface_remoteWakeup(void);

/* Endpoint 0 */
void USBBusInterface_EP0setup(uint8_t *buffer);
void USBBusInterface_EP0read(void);
uint32_t USBBusInterface_EP0getReadResult(uint8_t *buffer);
void USBBusInterface_EP0write(uint8_t *buffer, uint32_t size);
void USBBusInterface_EP0getWriteResult(void);
void USBBusInterface_EP0stall(void);

/* Other endpoints */
EP_STATUS USBBusInterface_endpointRead(uint8_t endpoint, uint8_t *data, uint32_t maximumSize);
EP_STATUS USBBusInterface_endpointReadResult(uint8_t endpoint, uint32_t *bytesRead);
EP_STATUS USBBusInterface_endpointWrite(uint8_t endpoint, uint8_t *data, uint32_t size);
EP_STATUS USBBusInterface_endpointWriteResult(uint8_t endpoint);
void USBBusInterface_stallEndpoint(uint8_t endpoint);
void USBBusInterface_unstallEndpoint(uint8_t endpoint);
bool USBBusInterface_realiseEndpoint(uint8_t endpoint, uint32_t maxPacket, uint32_t options);
bool USBBusInterface_getEndpointStallState(unsigned char endpoint);

#endif


