/* USBMouse.c */
/* USB device example: Relative mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "USBRawHID.h"

/*
 *  Descriptors
 */
 
#define RAWHID_USAGE_PAGE	0xFFAB	// recommended: 0xFF00 to 0xFFFF
#define RAWHID_USAGE		0x0200	// recommended: 0x0100 to 0xFFFF

uint8_t * USBRawHID::ReportDesc() {
    static uint8_t reportDescriptor[] = {

        /* Based on Appendix E.10 of "Device Class Definition for Human Interface
           Devices (HID)" Version 1.11. */

	0x06, LSB(RAWHID_USAGE_PAGE), MSB(RAWHID_USAGE_PAGE),
	0x0A, LSB(RAWHID_USAGE), MSB(RAWHID_USAGE),
	0xA1, 0x01,				// Collection 0x01
	0x75, 0x08,				// report size = 8 bits
	0x15, 0x00,				// logical minimum = 0
	0x26, 0xFF, 0x00,			// logical maximum = 255
	0x95, 64,			// report count
	0x09, 0x01,				// usage
	0x81, 0x02,				// Input (array)
	0xC0					// end collection
    };
    reportLength = sizeof(reportDescriptor);
    return reportDescriptor;
}

