/* USBMouse.h */
/* USB device example: relative mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _RELATIVE_MOUSE_
#define _RELATIVE_MOUSE_

#include "GenericMouse.h"
#include "USBHID.h"

/** USB device: a relative mouse
 *
 * Warning: you can only instantiate one instance of a USB device: USBMouse, USBKeyboard, USBAbsMouse, USBMouseKeyboard, or USBAbsMouseKeyboard.
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "USBMouse.h"
 *
 * USBMouse mouse;
 *
 * #define STEP (2)
 * #define SIZE (100)
 *
 * int main(void)
 * {
 *   int32_t a;
 *
 *   while (1)
 *   {
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(STEP,0);
 *       }
 *
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(0,STEP);
 *       }
 *
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(-STEP,0);
 *       }
 *
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(0,-STEP);
 *       }
 *   }
 * }
 *
 * @endcode
 */
class USBMouse: public GenericMouse, public USBHID
{
    public:
        
        /**
        *   Constructor for a USBMouse (relative mouse)
        */
        USBMouse(){};
        
        /**
        * Write a state of the mouse
        *
        * @param x x relative position
        * @param y y relative position
        * @param buttons buttons state (first bit represents MOUSE_LEFT, second bit MOUSE_RIGHT and third bit MOUSE_MIDDLE)
        * @param z wheel state (>0 to scroll down, <0 to scroll up)
        * @return true if there is no error, false otherwise
        */
        virtual bool update(int16_t x, int16_t y, uint8_t buttons, int8_t z);
        
        virtual uint8_t * ReportDesc();
        
    private:
        bool mouseSend(int8_t x, int8_t y, uint8_t buttons, int8_t z);
};

#endif