/* USBMouse.c */
/* USB device example: Relative mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "stdint.h"

#include "USBMouse.h"

/*
 *  Descriptors
 */

uint8_t * USBMouse::ReportDesc() {
    static uint8_t reportDescriptor[] = {

        /* Based on Appendix E.10 of "Device Class Definition for Human Interface
           Devices (HID)" Version 1.11. */

        USAGE_PAGE(1),      0x01,       /* Genric Desktop */
        USAGE(1),           0x02,       /* Mouse */
        COLLECTION(1),      0x01,       /* Application*/
        USAGE(1),           0x01,       /* Pointer */
        COLLECTION(1),      0x00,       /* Physical */

        REPORT_COUNT(1),    0x03,
        REPORT_SIZE(1),     0x01,
        USAGE_PAGE(1),      0x09,       /* Buttons */
        USAGE_MINIMUM(1),       0x1,
        USAGE_MAXIMUM(1),       0x3,
        LOGICAL_MINIMUM(1),     0x00,
        LOGICAL_MAXIMUM(1),     0x01,
        INPUT(1),           0x02,
        REPORT_COUNT(1),    0x01,
        REPORT_SIZE(1),     0x05,
        INPUT(1),           0x01,

        REPORT_COUNT(1),    0x03,
        REPORT_SIZE(1),     0x08,
        USAGE_PAGE(1),      0x01,
        USAGE(1),           0x30,       /* X */
        USAGE(1),           0x31,       /* Y */
        USAGE(1),           0x38,       /* scroll */
        LOGICAL_MINIMUM(1),     0x81,
        LOGICAL_MAXIMUM(1),     0x7f,
        INPUT(1),           0x06,       /* Relative data */

        END_COLLECTION(0),
        END_COLLECTION(0),
    };
    reportLength = sizeof(reportDescriptor);
    return reportDescriptor;
}


bool USBMouse::update(int16_t x, int16_t y, uint8_t button, int8_t z) {
    while (x > 127) {
        if (!mouseSend(127, 0, button, z)) return false;
        x = x - 127;
    }
    while (x < -128) {
        if (!mouseSend(-128, 0, button, z)) return false;
        x = x + 128;
    }
    while (y > 127) {
        if (!mouseSend(0, 127, button, z)) return false;
        y = y - 127;
    }
    while (y < -128) {
        if (!mouseSend(0, -128, button, z)) return false;
        y = y + 128;
    }
    return mouseSend(x, y, button, z);
}

bool USBMouse::mouseSend(int8_t x, int8_t y, uint8_t buttons, int8_t z) {
    HID_REPORT report;
    report.data[0] = buttons & 0x07;
    report.data[1] = x;
    report.data[2] = y;
    report.data[3] = -z; /* >0 to scroll down, <0 to scroll up */

    report.length = 4;

    return USBClass_HID_sendInputReport(EPINT_IN, &report);
}
