/* USBAbsMouse.c */

/* USB device example: an absolute mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "stdint.h"

#include "USBAbsMouse.h"

/*
 *  Descriptors
 */

uint8_t * USBAbsMouse::ReportDesc() {
    static uint8_t reportDescriptor[] = {

        /* Based on Appendix E.10 of "Device Class Definition for Human Interface
           Devices (HID)" Version 1.11 and modified to use absolute coordinates and a wheel. */

        USAGE_PAGE(1), 0x01,                    /* Generic Desktop */
        USAGE(1), 0x02,                         /* Mouse */
        COLLECTION(1), 0x01,                    /* Application*/
        USAGE(1), 0x01,                     /* Pointer */
        COLLECTION(1), 0x00,                /* Physical */

        USAGE_PAGE(1), 0x01,            /* Generic Desktop */
        USAGE(1), 0x30,                 /* X */
        USAGE(1), 0x31,                 /* Y */
        LOGICAL_MINIMUM(1), 0x00,       /* 0 */
        LOGICAL_MAXIMUM(2), 0xff, 0x7f, /* 32767 */
        REPORT_SIZE(1), 0x10,
        REPORT_COUNT(1), 0x02,
        INPUT(1), 0x02,                 /* Data, Variable, Absolute */

        USAGE_PAGE(1), 0x01,            /* Generic Desktop */
        USAGE(1), 0x38,                 /* scroll */
        LOGICAL_MINIMUM(1), 0x81,       /* -127 */
        LOGICAL_MAXIMUM(1), 0x7f,       /* 127 */
        REPORT_SIZE(1), 0x08,
        REPORT_COUNT(1), 0x01,
        INPUT(1), 0x06,                 /* Data, Variable, Relative */

        USAGE_PAGE(1), 0x09,            /* Buttons */
        USAGE_MINIMUM(1), 0x01,
        USAGE_MAXIMUM(1), 0x03,
        LOGICAL_MINIMUM(1), 0x00,       /* 0 */
        LOGICAL_MAXIMUM(1), 0x01,       /* 1 */
        REPORT_COUNT(1), 0x03,
        REPORT_SIZE(1), 0x01,
        INPUT(1), 0x02,                 /* Data, Variable, Absolute */
        REPORT_COUNT(1), 0x01,
        REPORT_SIZE(1), 0x05,
        INPUT(1), 0x01,                 /* Constant */

        END_COLLECTION(0),
        END_COLLECTION(0)
    };
    reportLength = sizeof(reportDescriptor);
    return reportDescriptor;
}


bool USBAbsMouse::update(int16_t x, int16_t y, uint8_t buttons, int8_t z) {
    HID_REPORT report;

    report.data[0] = x & 0xff;
    report.data[1] = (x >> 8) & 0xff;
    report.data[2] = y & 0xff;
    report.data[3] = (y >> 8) & 0xff;
    report.data[4] = -z;
    report.data[5] = buttons & 0x07;

    report.length = 6;

    return USBClass_HID_sendInputReport(EPINT_IN, &report);
}


