/* USBClass_HID.h */
/* Human Interface Device (HID) class */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_CLASS_HID_
#define _USB_CLASS_HID_

/* These headers are included for child class. */
#include "USBEndpoints.h"
#include "USBDescriptor.h"
#include "USBHID_Types.h"
#include "USBDevice_Types.h"
#include "USBDevice.h"
#include "asciihid.h"

#include "USBDevice.h"

bool USBClass_HID_request(void);
void USBClass_HID_requestCompleted(void);
bool USBClass_HID_sendInputReport(uint8_t endpoint, HID_REPORT *report);
bool USBClass_HID_getOutputReport(uint8_t endpoint, HID_REPORT *report);


class USBHID: public USBDevice
{
    public:
        //reportDesc is called to initalize the length of the report descriptor
        USBHID();
        virtual uint8_t * ReportDesc(){return NULL;};
        virtual uint16_t ReportDescLength();
        
        virtual void HID_callbackSetReport(HID_REPORT *report);
        
        virtual void USBCallback_busReset(void);
        virtual bool USBCallback_request();
        virtual void USBCallback_requestCompleted();
        virtual bool USBCallback_setConfiguration(uint8_t configuration);
        
    protected:
        uint16_t reportLength;
};

void setInstanceHID(USBHID * _inst);

#endif
