/* USBDevice.h */
/* Generic USB device */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_DEVICE_
#define _USB_DEVICE_

#include "mbed.h"           //for NULL
#include "USBDevice_Types.h"

bool USBDevice_init(void);
void USBDevice_uninit(void);
bool USBDevice_isConfigured(void);
void USBDevice_connect(void);
void USBDevice_disconnect(void);
CONTROL_TRANSFER *USBDevice_getTransferPtr(void);
bool USBDevice_addEndpoint(uint8_t endpoint, uint32_t maxPacket);
bool USBDevice_addRateFeedbackEndpoint(uint8_t endpoint, uint32_t maxPacket);


/* Endpoint events that must be implemented by device layer: */
void USBDevice_EP0setup(void);
void USBDevice_EP0out(void);
void USBDevice_EP0in(void);

/* Endpoint events that are optionally implemented by device layer: */
void USBDevice_busReset(void);
void USBDevice_SOF(uint16_t frameNumber);
void USBDevice_connectStateChanged(unsigned int state);
void USBDevice_suspendStateChanged(unsigned int state);

uint8_t * USBDevice_findDescriptor(uint8_t descriptorType);

class USBDevice
{
    public:
        USBDevice();
        virtual void USBCallback_busReset(void){};
        virtual bool USBCallback_request(){return false;};
        virtual void USBCallback_requestCompleted(){};
        virtual bool USBCallback_setConfiguration(uint8_t configuration){return false;};
        
        virtual uint8_t * DeviceDesc();
        virtual uint8_t * ConfigurationDesc();
        virtual uint8_t * StringLangidDesc();
        virtual uint8_t * StringImanufacturerDesc();
        virtual uint8_t * StringIproductDesc();
        virtual uint8_t * StringIserialDesc();
        virtual uint8_t * StringIConfigurationDesc();
        virtual uint8_t * StringIinterfaceDesc();
        virtual uint16_t ReportDescLength(){return 0;};
};


void setInstanceDevice(USBDevice * _inst);


#endif
