/* USBKeyboard.h */
/* USB device example: Standard keyboard */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_KEYBOARD_
#define _USB_KEYBOARD_

#include "GenericKeyboard.h"
#include "USBHID.h"

/** USB device: a keyboard
 *
 * Warning: you can only instantiate one instance of a USB device: USBMouse, USBKeyboard, USBAbsMouse, USBMouseKeyboard, or USBAbsMouseKeyboard.
 *
 * Example:
 * @code
 *
 * #include "mbed.h"
 * #include "USBKeyboard.h"
 *
 * USBKeyboard key;
 * 
 * int main(void)
 * {
 *   while (1)
 *   {
 *       key.puts("Hello World\r\n");
 *       wait(1);
 *   }
 * }
 *
 * @endcode
 */
class USBKeyboard: public GenericKeyboard, public USBHID
{
    public:
        /**
        * Constructor for a keyboard
        */
        USBKeyboard(){};
        
        virtual uint8_t * ReportDesc();
        
        
};

#endif
