/* USBKeyboard.c */
/* USB device example: Standard keyboard */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "stdint.h"

#include "USBKeyboard.h"

/*
 *  Descriptors
 */

uint8_t * USBKeyboard::ReportDesc() {
    static uint8_t reportDescriptor[] = {

        /* Based on Appendix E.6 of "Device Class Definition for Human Interface
           Devices (HID)" Version 1.11. */

        USAGE_PAGE(1), 0x01,                    /* Generic Desktop */
        USAGE(1), 0x06,                         /* Keyboard */
        COLLECTION(1), 0x01,                    /* Application*/
        REPORT_ID(1),       REPORT_ID_KEYBOARD,

        USAGE_PAGE(1), 0x07,                    /* Key Codes */
        USAGE_MINIMUM(1), 0xE0,
        USAGE_MAXIMUM(1), 0xE7,
        LOGICAL_MINIMUM(1), 0x00,
        LOGICAL_MAXIMUM(1), 0x01,
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x08,
        INPUT(1), 0x02,                         /* Data, Variable, Absolute */
        REPORT_COUNT(1), 0x01,
        REPORT_SIZE(1), 0x08,
        INPUT(1), 0x01,                         /* Constant */
        REPORT_COUNT(1), 0x05,
        REPORT_SIZE(1), 0x01,


        USAGE_PAGE(1), 0x08,                    /* LEDs */
        USAGE_MINIMUM(1), 0x01,
        USAGE_MAXIMUM(1), 0x05,
        OUTPUT(1), 0x02,                        /* Data, Variable, Absolute */
        REPORT_COUNT(1), 0x01,
        REPORT_SIZE(1), 0x03,
        OUTPUT(1), 0x01,                        /* Constant */
        REPORT_COUNT(1), 0x06,
        REPORT_SIZE(1), 0x08,
        LOGICAL_MINIMUM(1), 0x00,
        LOGICAL_MAXIMUM(1), 0x65,


        USAGE_PAGE(1), 0x07,                    /* Key Codes */
        USAGE_MINIMUM(1), 0x00,
        USAGE_MAXIMUM(1), 0x65,
        INPUT(1), 0x00,                         /* Data, Array */
        END_COLLECTION(0),

        /* Media Control */
        USAGE_PAGE(1), 0x0C,
        USAGE(1), 0x01,
        COLLECTION(1), 0x01,
        REPORT_ID(1), REPORT_ID_VOLUME,
        USAGE_PAGE(1), 0x0C,
        LOGICAL_MINIMUM(1), 0x00,
        LOGICAL_MAXIMUM(1), 0x01,
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x07,
        USAGE(1), 0xB5,             /* Next Track */
        USAGE(1), 0xB6,             /* Previous Track */
        USAGE(1), 0xB7,             /* Stop */
        USAGE(1), 0xCD,             /* Play / Pause */
        USAGE(1), 0xE2,             /* Mute */
        USAGE(1), 0xE9,             /* Volume Up */
        USAGE(1), 0xEA,             /* Volume Down */
        INPUT(1), 0x02,             /* Input (Data, Variable, Absolute) */
        REPORT_COUNT(1), 0x01,
        INPUT(1), 0x01,
        END_COLLECTION(0),

    };
    reportLength = sizeof(reportDescriptor);
    return reportDescriptor;
}
