/* USBAbsMouseKeyboard.h */
/* USB device example: keyboard and an absolute mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_KEYBOARD_ABS_MOUSE_
#define _USB_KEYBOARD_ABS_MOUSE_

#include "GenericMouse.h"
#include "GenericKeyboard.h"
#include "USBHID.h"


/** USB device: a keyboard and an absolute mouse
 *
 * Warning: you can only instantiate one instance of a USB device: USBMouse, USBKeyboard, USBAbsMouse, USBMouseKeyboard, or USBAbsMouseKeyboard.
 *
 * Example:
 * @code
 *
 * #include "mbed.h"
 * #include "USBAbsMouseKeyboard.h"
 *
 * USBAbsMouseKeyboard key_mouse;
 *
 * #define STEP (1000)
 *
 * int main(void)
 * {
 *   int32_t a = X_MIN;
 *   int32_t dir = STEP;
 *
 *   while (1)
 *   {
 *       key_mouse.move(a, a);
 *       key_mouse.puts("Hello From Mbed\r\n");
 *
 *       if (((a+dir) > X_MAX) || ((a+dir) < X_MIN))
 *       {
 *           // Change direction
 *           dir = -dir;
 *       }
 *       a += dir;
 *
 *       wait(1);       
 *   }
 * }
 * @endcode
 */
class USBAbsMouseKeyboard: public GenericMouse, public GenericKeyboard, public USBHID
{
    public:
    
        /**
        *   Constructor for an absolute mouse and a keyboard
        */
        USBAbsMouseKeyboard(){};
        
        /**
        * Write a state of the mouse
        *
        * @param x x absolute position
        * @param y y absolute position
        * @param buttons buttons state (first bit represents MOUSE_LEFT, second bit MOUSE_RIGHT and third bit MOUSE_MIDDLE)
        * @param z wheel state (>0 to scroll down, <0 to scroll up)
        * @return true if there is no error, false otherwise
        */
        virtual bool update(int16_t x, int16_t y, uint8_t buttons, int8_t z);
        
        virtual uint8_t * ReportDesc();
};

#endif
