/* Keyboard_AbsMouse.c */

/* USB device example: Keyboard and an absolute mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "stdint.h"

#include "USBAbsMouseKeyboard.h"


uint8_t * USBAbsMouseKeyboard::ReportDesc() {
    static uint8_t reportDescriptor[] = {

        /* Keyboard */
        USAGE_PAGE(1),      0x01,
        USAGE(1),           0x06,
        COLLECTION(1),      0x01,
        REPORT_ID(1),       REPORT_ID_KEYBOARD,
        USAGE_PAGE(1),      0x07,
        USAGE_MINIMUM(1),       0xE0,
        USAGE_MAXIMUM(1),       0xE7,
        LOGICAL_MINIMUM(1),     0x00,
        LOGICAL_MAXIMUM(1),     0x01,
        REPORT_SIZE(1),     0x01,
        REPORT_COUNT(1),    0x08,
        INPUT(1),           0x02,
        REPORT_COUNT(1),    0x01,
        REPORT_SIZE(1),     0x08,
        INPUT(1),           0x01,
        REPORT_COUNT(1),    0x05,
        REPORT_SIZE(1),     0x01,
        USAGE_PAGE(1),      0x08,
        USAGE_MINIMUM(1),       0x01,
        USAGE_MAXIMUM(1),       0x05,
        OUTPUT(1),          0x02,
        REPORT_COUNT(1),    0x01,
        REPORT_SIZE(1),     0x03,
        OUTPUT(1),          0x01,
        REPORT_COUNT(1),    0x06,
        REPORT_SIZE(1),     0x08,
        LOGICAL_MINIMUM(1),     0x00,
        LOGICAL_MAXIMUM(2),     0xff, 0x00,
        USAGE_PAGE(1),      0x07,
        USAGE_MINIMUM(1),       0x00,
        USAGE_MAXIMUM(2),       0xff, 0x00,
        INPUT(1),           0x00,
        END_COLLECTION(0),

        /* Mouse */


        USAGE_PAGE(1), 0x01,                    /* Generic Desktop */
        USAGE(1), 0x02,                         /* Mouse */
        COLLECTION(1), 0x01,                    /* Application*/
        USAGE(1), 0x01,                         /* Pointer */
        COLLECTION(1), 0x00,                    /* Physical */
        REPORT_ID(1),       REPORT_ID_MOUSE,

        USAGE_PAGE(1), 0x01,                /* Generic Desktop */
        USAGE(1), 0x30,                     /* X */
        USAGE(1), 0x31,                     /* Y */
        LOGICAL_MINIMUM(1), 0x00,           /* 0 */
        LOGICAL_MAXIMUM(2), 0xff, 0x7f,     /* 32767 */
        REPORT_SIZE(1), 0x10,
        REPORT_COUNT(1), 0x02,
        INPUT(1), 0x02,                     /* Data, Variable, Absolute */

        USAGE_PAGE(1), 0x01,                /* Generic Desktop */
        USAGE(1), 0x38,                     /* scroll */
        LOGICAL_MINIMUM(1), 0x81,           /* -127 */
        LOGICAL_MAXIMUM(1), 0x7f,           /* 127 */
        REPORT_SIZE(1), 0x08,
        REPORT_COUNT(1), 0x01,
        INPUT(1), 0x06,                     /* Data, Variable, Relative */

        USAGE_PAGE(1), 0x09,                /* Buttons */
        USAGE_MINIMUM(1), 0x01,
        USAGE_MAXIMUM(1), 0x03,
        LOGICAL_MINIMUM(1), 0x00,           /* 0 */
        LOGICAL_MAXIMUM(1), 0x01,           /* 1 */
        REPORT_COUNT(1), 0x03,
        REPORT_SIZE(1), 0x01,
        INPUT(1), 0x02,                     /* Data, Variable, Absolute */
        REPORT_COUNT(1), 0x01,
        REPORT_SIZE(1), 0x05,
        INPUT(1), 0x01,                     /* Constant */

        END_COLLECTION(0),
        END_COLLECTION(0),




        USAGE_PAGE(1), 0x0c,                        /* USAGE_PAGE (Consumer Devices) */
        USAGE(1), 0x01,                             /* USAGE (Consumer Control) */
        COLLECTION(1), 0x01,                        /* COLLECTION (Application) */
        REPORT_ID(1),       REPORT_ID_VOLUME,
        LOGICAL_MINIMUM(1), 0x00,                   /*   LOGICAL_MINIMUM (0) */
        LOGICAL_MAXIMUM(1), 0x01,                   /*   LOGICAL_MAXIMUM (1) */
        USAGE(1), 0xe9,                             /*   Volume Up */
        USAGE(1), 0xea,                             /*   Volume Down */
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x02,
        INPUT(1), 0x06,                             /*   INPUT (Data,Var,Rel) */
        USAGE(1), 0xe2,                             /*   Mute */
        REPORT_COUNT(1), 0x01,                      /*   REPORT_COUNT (1) */
        INPUT(1), 0x06,                             /*   INPUT (Data,Var,Rel) */
        REPORT_COUNT(1), 0x05,                      /*   REPORT_COUNT (5) */
        INPUT(1), 0x07,                             /*   INPUT (Cnst,Var,Rel) */
        END_COLLECTION(0),                          /* END_COLLECTION */
    };
    reportLength = sizeof(reportDescriptor);
    return reportDescriptor;
}



/*
 *  Mouse API for user application
 */


bool USBAbsMouseKeyboard::update(int16_t x, int16_t y, uint8_t buttons, int8_t z) {
    HID_REPORT report;

    report.data[0] = REPORT_ID_MOUSE;
    report.data[1] = x & 0xff;
    report.data[2] = (x >> 8) & 0xff;
    report.data[3] = y & 0xff;
    report.data[4] = (y >> 8) & 0xff;
    report.data[5] = -z;
    report.data[6] = buttons & 0x07;

    report.length = 7;

    return USBClass_HID_sendInputReport(EPINT_IN, &report);
}

