/* AbsoluteMouse.c */

/* USB device example: an absolute mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "stdint.h"

#include "GenericMouse.h"

bool GenericMouse::move(int16_t x, int16_t y) {
    return update(x, y, button, 0);
}

bool GenericMouse::scroll(int8_t z) {
    return update(0, 0, button, z);
}


bool GenericMouse::doubleClick() {
    if (!click(MOUSE_LEFT))
        return false;
    wait(0.1);
    return click(MOUSE_LEFT);
}

bool GenericMouse::click(uint8_t button) {
    if (!update(0, 0, button, 0))
        return false;
    wait(0.01);
    return update(0, 0, 0, 0);
}

bool GenericMouse::press(uint8_t button_) {
    button = button_ & 0x07;
    return update(0, 0, button, 0);
}

bool GenericMouse::release(uint8_t button_) {
    button = (button & (~button_)) & 0x07;
    return update(0, 0, button, 0);
}
