#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"
#include "LM75B.h"
#include "MMA7660.h"


/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p30 is for the reset pin
*     - p29 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/

WiflyInterface wifly(p9, p10, p30, p29, "mbed", "password", WPA);

// accelerometer
MMA7660 acc(p28, p27);

// temperature sensor
LM75B tmp(p28,p27);


int main()
{
    char json_str[100];

    wifly.init(); //Use DHCP
    while (!wifly.connect());
    printf("IP Address is %s\n\r", wifly.getIPAddress());

    // See the output on http://sockets.mbed.org/app-board/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/app-board/wo");
    
    // connect WS server
    while (!ws.connect());

    while (1) {
        // create json string with acc/tmp data
        sprintf(json_str, "{\"id\":\"app_board_wifly_EW2013\",\"ax\":%d,\"ay\":%d,\"az\":%d, \"tmp\":%d}", (int)(acc.x()*360), (int)(acc.y()*360), (int)(acc.z()*360), (int)tmp.read());
        
        // send str
        ws.send(json_str);
        
        wait(0.1);
    }
}