#include "mbed.h"
#include "WiflyInterface.h"
#include "HTTPClient.h"

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p30, p29, "mbed", "password", WPA);
HTTPClient http;

char str[512];

int main()
{
    wifly.init(); //Use DHCP

    wifly.connect();

    //GET data
    printf("Trying to fetch page...\n");
    int ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret) {
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    //POST data
    HTTPMap map;
    HTTPText text(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("Trying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &text);
    if (!ret) {
        printf("Executed POST successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    wifly.disconnect();

    while(1) {
    }
}