#include "mbed.h"
#include "SprintUSBModem.h"
#include "Websocket.h"
#include "MMA7660.h"

MMA7660 MMA(p28, p27);

void test(void const*) 
{
    SprintUSBModem modem(p18);  
    Websocket ws("ws://sockets.mbed.org:443/ws/sensors/wo");
    // View the output at :
    // http://tools.mbed.org/iot/
    // Click "show all"
    char json_str[100];
    Thread::wait(5000);
    printf("Switching power on\r\n");    
    
    modem.power(true);
    
    int ret = modem.connect();
    if(ret)
    {
      printf("Could not connect\r\n");
      return;
    }
    
    bool c = ws.connect();
    printf("Connect result: %s\r\n", c?"OK":"Failed");
    
    while (1) {
        sprintf(json_str, "{\"id\":\"mbed-app-board\",\"ax\":\"%d\",\"ay\":\"%d\",\"az\":\"%d\"}", (int)(MMA.x()*200), (int)(MMA.y()*200), (int)(MMA.z()*200));
        ws.send(json_str);
        wait(0.2);
    }
    
}


int main()
{
  DBG_INIT();
  DBG_SET_SPEED(115200);
  DBG_SET_NEWLINE("\r\n");
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
