#include "mbed.h"
#include "SprintUSBModem.h"
#include "HTTPClient.h"

void test(void const*) 
{
    SprintUSBModem modem(p18);
    HTTPClient http;
    char str[512];
    
    Thread::wait(5000);
    printf("Switching power on\r\n");
    
    modem.power(true);
    
    int ret = modem.connect();
    if(ret)
    {
      printf("Could not connect\n");
      return;
    }
    
    //GET data
    printf("Trying to fetch page...\n");
    ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText text(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("Trying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &text);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    modem.disconnect(); 
    
    modem.power(false); 

    while(1) {
    }
}


int main()
{
  DBG_INIT();
  DBG_SET_SPEED(115200);
  DBG_SET_NEWLINE("\r\n");
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
