#include "mbed.h"
#include "SprintUSBModem.h"
#include "LM75B.h"

LM75B tmp(p28,p27);

#define MY_PHONE_NUMBER "+447957363267"

void test(void const*)
{
    DigitalOut led4(LED4);
    SprintUSBModem modem(p18);
    char msg[128];


    printf("Switching power on\r\n");
    modem.power(true);

    modem.sendSM(MY_PHONE_NUMBER, "Hello from mbed:)");

    while(true) {
        if (tmp.read() > 32.0) {
            led4 = 1;
            sprintf(msg,"Temperature : %.1f!",tmp.read());
            modem.sendSM(MY_PHONE_NUMBER, msg);
            while (tmp.read() > 30.0) {
                Thread::wait(1000);
            }
            led4=0;
        }
    }

    modem.disconnect();

    modem.power(false);

}


int main()
{
    DBG_INIT();
    DBG_SET_SPEED(115200);
    DBG_SET_NEWLINE("\r\n");
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
    DigitalOut led(LED1);
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
