#include "Objects.h"
#include "Helper.h"
#include "Tests.h"


//#define AUDIO // it beeps at the end

#define TEST_DELAY 0.001


// ============================
// Tests
// The numbers are used to trigger
// The test on the DUT
// ============================
// 1. VoltageCurrent
// 2. DUTSetupTest
// 3. IOTest
// 4. Resettest
// 5. BatteryTest
// 6. EthernetTest
// ============================
// Assumptions
// ============================
// All tests run off the initial VUSB power up
//    Vin test explicity fiddles the power
// ============================

int wibble=1;

int main() {

   DutReset(1);
  
   
   char result=0;
   
   pc.printf("mbed-005.1 Production test jig\n");

      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("Reflash jig");
      lcd.locate(0,1);
      lcd.printf("Press GREEN");


   DutISPConnect();
   
   wait(0.5);

   while (wibble) {
   
      // wait for the button to be pressed
      while (!gbtn) {}     
      // Power up 
      DutUsbPowerUp();
      wait (1.0);
   

      // wait for the button to be pressed
      while (!gbtn) {}     
      // Power down
      DutUsbPowerDown();
      wait (1.0);
   
   
   
   }


   while (1) {
       
       
       
       
       
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("mbed-005.1 Test");
      lcd.locate(0,1);
      lcd.printf("Press GREEN");
   
      // wait for the button to be pressed
      while (!gbtn) {}
     
      // Power up USB and connect
      DutUsbPowerUp();
      wait (0.1);



// Connect the USB after the current test
// this stops the spiking currents during enumeration from 
// giving false readings
//      DutUsbConnect();
//      wait (0.5);


// ========================
// Voltage and current test
// ========================
            


      lcd.locate(0,1);
      lcd.printf("VCTest          ");
      wait (TEST_DELAY);

      result |= VCTest ();
      pc.printf("VCTest 0x%x\n",result);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}


// ========================
// Connect USB
// ========================

      DutUsbConnect();
      wait (0.5);
                    
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("Copy TestDUT.bin");
      lcd.locate(0,1);
      lcd.printf("Press GREEN");
      wait(0.5);
      
      // wait for the button to be pressed
      while (!gbtn) {}   
    
      // turn off the board and USB, and power it up using VIN
      DutUsbPowerDown();
      DutUsbDisconnect();
      
      wait (0.2);
      DutVinPowerUp();

      // Turn on the VB power, this is so it can stablise
      DutVB(1);
      VBatGnd=1;

      // this covers the debug case when the board
      // remains powered by USB
      DUT_NR = 0;
      wait (0.1);
      DUT_NR = 1;
      

      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("Waiting for DUT");
      
      
      // this is where the DUT power up... it will take a bunch of time
      // for the binary to be programmed
      // We should wait for a "R" to be sent by the DUT

      DutBufferFlush();  
      // wait here until 
      while (!Dut.readable()) {
          led4 = !led4;
          wait (0.05);
      }
        
      char tmp = Dut.getc();

      if ( tmp != 'R' ) {
      }


      // Start the test
      lcd.locate(0,1);
      lcd.printf("Testing...");




//// ///////////////////////////////////////////////////////
//// This is where we do the grunt work of running the tests
//// ///////////////////////////////////////////////////////




    


    
// ========================
// Dut setup
// ========================
    
      lcd.locate(0,1);
      lcd.printf("DutSetupTest");
      result |= DutSetupTest ();    
      pc.printf("DutSetup 0x%x\n",result);
      wait (TEST_DELAY);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}


// ========================
// IO Test
// ========================
      
      lcd.locate(0,1);
      lcd.printf("IOTest          ");
      result |= IOTest ();
      pc.printf("IOTest 0x%x\n",result);
      wait (TEST_DELAY);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}


// ========================
// Reset Test
// ========================

      lcd.cls(); lcd.locate(0,0);
      lcd.printf("ResetTest");
      result |= ResetTest ();
      pc.printf("ResetTest 0x%x\n",result);
      wait (TEST_DELAY);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}


// ========================
// Ethernet test
// ========================


      lcd.cls(); lcd.locate(0,0);
      lcd.printf("EthernetTest");
      result |= EthernetTest ();
      pc.printf("EthernetTest 0x%x\n",result);
      wait (TEST_DELAY);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}



// ========================
// RTC Test
// ========================


      lcd.cls(); lcd.locate(0,0);
      lcd.printf("RTC test");
      
      result |= RTCTest ();
      pc.printf("RTCtTest 0x%x\n",result);
      wait (TEST_DELAY);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}




// ========================
// VBat Test
// ========================


// make sure the clock still has a sensible value

      lcd.cls(); lcd.locate(0,0);
      lcd.printf("VBat test");
            
      // Turn off all other power
      DutVinPowerDown();
      
      // wait for 1 second
      wait(0.1);
      
      // power back on
      DutVinPowerUp();
      wait (0.1);

      // flush the buffer (there will be an "R")
      DutBufferFlush();      
      
      result |= BatteryTest ();
      pc.printf("VBatTest 0x%x\n",result);
      wait (TEST_DELAY);

      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}







    
// ========================
// Clean up
// ========================
    
      lcd.cls(); lcd.locate(0,0);
      if (result==0) {
          result |= CleanUp ();
      }



      gled=0; rled=0; wait (0.05);
      if (result == 0 ) {gled = 1; rled=0;} else {gled = 0; rled=1;}

    
      // non-zero, Dut failed
      if (result) {
          lcd.cls(); lcd.locate(0,0);
          lcd.printf("Failed : 0x%x",result);   
          gled = 0; rled=1;
          lcd.locate(0,1);
          lcd.printf("Info in Test.log",result);   



          // Power up USB and connect
          DutUsbPowerUp();
          wait (0.1);
          DutUsbConnect();
          wait (0.5);


          #ifdef AUDIO
              Beep(500,0.5);
          #endif
          
       

          
      } else {
          lcd.cls(); 
          lcd.locate(0,0);
          lcd.printf("Passed! :-)");

          lcd.locate(0,1);
          lcd.printf("Press GREEN");
          gled = 1; rled=0;
          
          #ifdef AUDIO
              Beep(4000,0.5);
          #endif
      }

//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

      
      // wait for the button to be pressed
      while (!gbtn) {}
      wait(0.1);

      // Clean up for the next pass
      result = 0;       
      rled=0;
      gled=0;
      DutUsbPowerDown ();
      DutUsbDisconnect ();
      DutVinPowerDown ();
      DutReset (1);
      DutVB (0);
      
      
   
   } // end of while
   
}  // end of main




















