#include "Objects.h"
#include "Helper.h"


int JigData=0x0;


#ifdef I2CIO


void DutVinPowerUp (void)  {
    JigData |= 0x01;
    JigIO.write(JigData);
}

void DutVinPowerDown (void) {
    JigData &= 0xFE;
    JigIO.write(JigData);
}


void DutUsbPowerUp (void) {
    JigData |= 0x02;
    JigIO.write(JigData);
}

void DutUsbPowerDown (void) {
    JigData &= 0xFD;
    JigIO.write(JigData);
}

void DutUsbConnect (void) {
    JigData |= 0x04;
    JigIO.write(JigData);
}

void DutUsbDisconnect (void) {
    JigData |= 0xFB;
    JigIO.write(JigData);
}


void DutISPConnect (void)  {
    JigData |= 0x08;
    JigIO.write(JigData);
}

void DutISPDisconnect (void)  {
    JigData |= 0xF7;
    JigIO.write(JigData);
}


#else

    void DutUsbPowerUp (void) {VBUSrelay=1;}
    void DutUsbPowerDown (void) {VBUSrelay=0;}
    void DutUsbConnect (void) {USBrelay=1;}
    void DutUsbDisconnect (void) {USBrelay=0;}
    void DutVinPowerUp (void) {VINrelay=1;}
    void DutVinPowerDown (void) {VINrelay=0;}

#endif




void DutReset (int value) {DUT_NR = value;}
void DutVB (int value) {DUT_VB=value;}





void Beep (int Hz, float time) {
    piezo.period(1.0/float(Hz));
    piezo=0.5;
    wait(time);
    piezo=0.0;
}






void DutBufferFlush(void) {
  while(Dut.readable()) {char tmp=Dut.getc();}
}
