#include "Helper.h"
#include "Objects.h"
#include "Tests.h"


//// ///////////////////////////////////////////////////////
//// Measure the voltages and Idut
//// should see 0.757 (2.5v) and (0.5) 1.65v
//// Expect Idut to be below 180mA
//// expect to read below 0.11 across a 2R shunt.
//// ///////////////////////////////////////////////////////

int VCTest (void) {
    
    int result=0;
    
    float tmp_v3v3=0.0; 
    float tmp_v5v0=0.0;
    float duti = 0.0;
        

    for (int i=0; i<100 ; i++){
        tmp_v5v0 = (tmp_v5v0 + v5v0)/2.0;
        tmp_v3v3 = (tmp_v3v3 + v3v3)/2.0;
        duti = (duti + idut*0.33)/2.0; // this give the number in mA
        wait(0.001);
    }    
    
    
    pc.printf("idut = %fmA\n",(duti*1000.0));
    pc.printf("v3v3 = %f\n",tmp_v3v3);
    pc.printf("v5v0 = %f\n",tmp_v5v0);


    // Test the current
    // somewhere between 90mA and 200mA
    if ((duti < 0.09) || (duti > 0.2)) {
        //result |= 0x1;
        
    }


    // Test the 3v3 rail 
    // give a 10% leaway for tolerance and instrumentation error
    if ((tmp_v3v3 < 0.45) || (tmp_v3v3 > 0.575)) {
        result |= 0x1;
    }
    
    // Test the 5v0 rail 
    // give a 10% leaway for tolerance and instrumentation error
    if ((tmp_v5v0 < 0.68) || (tmp_v5v0 > 0.835)) {
        result |= 0x1;
    }

    return(result);
    
}



//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int DutSetupTest (void) {
   
   int result=0;

    DutBufferFlush();
    
    Dut.printf("S2");
    
    led2 = 1;

    // wait here until 
    while (!Dut.readable()) {
        led1 = !led1;
        wait (0.05);
    }
    
    
    char tmp = Dut.getc();
    
    if ( tmp != 'P' ) {
        result |= DUTSETUPTEST_FAILED;        
    }
    
    return(result);
}



//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int IOTest (void) {
   
   int result=0;

    DutBufferFlush();
    Dut.printf("S3");
    
    // wait here until 
    while (!Dut.readable()) {}
    char tmp = Dut.getc();
    
    if ( tmp != 'P' ) {
        result |= IOTEST_FAILED;        
    }
    
    return(result);
}

//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int ResetTest (void) {

   int result=0;

    DutBufferFlush();

    // this should hang the target in a while(1) loop
    Dut.printf("S4");

    // reset the target
    DUT_NR = 0;
    wait(0.1);
    DUT_NR = 1;

    
    // Expect to hear that character back

    // wait here until 
    while (!Dut.readable()) {}
    char tmp = Dut.getc();
    
    if ( tmp != 'R' ) {
        result |= RESETTEST_FAILED;        
    }
    
    return(result);

}

//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int BatteryTest (void) {
    int result=0;
    
    // Run the test on the dut. This should ensure the RTC has a sensible value.
    // after the power down
    
    DutBufferFlush();
    Dut.printf("S5");
    
    // wait here until 
    while (!Dut.readable()) {}
    char tmp = Dut.getc();
    
    if ( tmp != 'P' ) {
        result |= BATTERYTEST_FAILED;        
    }
    
    return(0);
}


//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int RTCTest (void) {
    int result=0;
    
    // Run the test on the dut. This should ensure the RTC has a sensible value.
    // after the power down
    DutBufferFlush();
    Dut.printf("S5");
    
    // wait here until 
    while (!Dut.readable()) {}
    char tmp = Dut.getc();
    
    if ( tmp != 'P' ) {
        result |= RTCTEST_FAILED;        
    }
    
    return(result);
}




//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int EthernetTest (void) {
   int result=0;

    DutBufferFlush();
    Dut.printf("S6");
    
    // wait here until 
    while (!Dut.readable()) {}
    char tmp = Dut.getc();
    
    if ( tmp != 'P' ) {
        result |= ETHERNETTEST_FAILED;        
    }
    
    return(result);
}




//// ///////////////////////////////////////////////////////
//// 
//// ///////////////////////////////////////////////////////

int CleanUp (void) {
   int result=0;

    DutBufferFlush();
    Dut.printf("S7");
    
    // wait here until 
    while (!Dut.readable()) {led3 = !led3; wait (0.1);}
    char tmp = Dut.getc();
    
    if ( tmp != 'P' ) {
        result |= CLEANUP_FAILED;        
    }
    
    return(result);
}

