/* Copyright (c) 2012 cstyles, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef WS2812_H
#define WS2812_H

#include "mbed.h"

#define WS1 0x38
#define WS0 0x30
#define SPICLK 5000000
#define SPIBPF 6


//!Library for the WS2812 RGB LED with integrated controller
/*!
The WS2812 is controller that is built into a range of LEDs
*/
class WS2812
{
public:
    //!Creates an instance of the class.
    /*!
    Connect WS2812 address addr using SPI MOSI pins
    */
    WS2812(PinName d, int size);

    /*!
    Destroys instance.
    */
    ~WS2812();

    //!Reads the current temperature.
    /*!
    Reads the temperature register of the LM75B and converts it to a useable value.
    */
    void write (int buf[]);
    void write_offsets (int buf[],int r_offset=0, int g_offset=0, int b_offset=0);
    void setAll(int colour);

    void useII(int d);
    void setII(unsigned char II);
    


private:

    int __size;
    unsigned char __II;
    int __use_II;
    SPI __spi;
    void __write (int color);


};

#endif