#include "mbed.h"
#include "SprintUSBModem.h"
#include "Websocket.h"
#include "LM75B.h"

void test(void const*)
{
    LM75B tmp(p28,p27);

    SprintUSBModem modem;
    // view at http://sockets.mbed.org/demo/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");

    char recv[128];
    char msg[32];

    modem.power(true);

    int ret = modem.connect();
    if(ret) {
        printf("Could not connect\r\n");
        return;
    }

    bool c = ws.connect();
    printf("Connect result: %s\r\n", c?"OK":"Failed");

    while (1) {

        sprintf(msg, "Temp = %.1f",tmp.read());
        int ret = ws.send(msg);
        if(ret<0) {
            printf("Timeout\r\n");
            ws.close();
            c = ws.connect();
            printf("Connect result: %s\r\n", c?"OK":"Failed");
        }
        Thread::wait(1000);

    }

    modem.disconnect();

    printf("Disconnected\r\n");

    modem.power(false);

    printf("Powered off\r\n");

    while(1) {
    }
}


int main()
{
    DBG_INIT();
    DBG_SET_SPEED(115200);
    DBG_SET_NEWLINE("\r\n");
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
    DigitalOut led(LED1);
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
