#include "mbed.h"
#include "SprintUSBModem.h"
#include "Websocket.h"
#include "C12832_lcd.h"

void test(void const*)
{

    SprintUSBModem modem;
    // Send messages at http://sockets.mbed.org/demo/sender
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/ro");

    char recv[128];

    modem.power(true);

    int ret = modem.connect();
    if(ret) {
        printf("Could not connect\r\n");
        return;
    }

    bool c = ws.connect();
    printf("Connect result: %s\r\n", c?"OK":"Failed");

    C12832_LCD lcd;
    lcd.cls();

    while (1) {

        if (ws.read(recv)) {
            printf("rcv: %s\r\n", recv);
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf(recv);
        }

        Thread::wait(1000);
    }

    modem.disconnect();

    printf("Disconnected\r\n");

    modem.power(false);

    printf("Powered off\r\n");

}


int main()
{
    DBG_INIT();
    DBG_SET_SPEED(115200);
    DBG_SET_NEWLINE("\r\n");
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
    DigitalOut led(LED1);
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
