#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "AX12.h"
#include "TextLCD.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AX12 sm1 (p9, p10, 1);
AX12 sm2 (p9, p10, 2);

EthernetNetIf eth;
HTTPClient http;

void DeliverSnack1 () {
    
    float pos = 0.0;
    float goal = 0.0;

    led1 = 1;

    // read the position of the servo
    pos = sm1.GetPosition();

    // work out where we need to position the servo
    // we always align to 60^ boundary
    
    sm1.SetCRSpeed(0.7);
    if ((pos > 0.0) && (pos < 60.0)) {
        goal = 60.0;
    } else if ((pos > 60.0) && (pos < 120.0)) {
        goal = 120.0;
    } else if ((pos > 120.0) && (pos < 180.0)) {
        goal = 180.0;
    } else if ((pos > 180.0) && (pos < 240.0)) {
        goal = 240.0;
    } else if ((pos > 240.0) && (pos < 295.0)) {
        goal = 295.0;
    } else {
        goal = 2.0;
    }

    do {
        pos = sm1.GetPosition();
        // there is a quirk in the 300-360 dead band of the AX12
        // where it reads ~120^, briefly
        if ((goal == 2.0) && (pos > 50.0)) {
            pos = 0.0;
        }
        printf("%.2f\n",pos);
    } while (pos < goal);


    sm1.SetCRSpeed(0.0);

    wait (2.0);
    led1 = 0;
}

void DeliverSnack2 () {

    float pos = 0.0;
    float goal = 0.0;

    led2 = 1;

    // read the position of the servo
    pos = sm2.GetPosition();

    // work out where we need to position the servo
    // we always align to 60^ boundary
    sm2.SetCRSpeed(0.7);
    if ((pos > 0.0) && (pos < 60.0)) {
        goal = 60.0;
    } else if ((pos > 60.0) && (pos < 120.0)) {
        goal = 120.0;
    } else if ((pos > 120.0) && (pos < 180.0)) {
        goal = 180.0;
    } else if ((pos > 180.0) && (pos < 240.0)) {
        goal = 240.0;
    } else if ((pos > 240.0) && (pos < 295.0)) {
        goal = 295.0;
    } else {
        goal = 2.0;
    }

    do {
        pos = sm2.GetPosition();
        // there is a quirk in the 300-360 dead band of the AX12
        // where it reads ~120^, briefly
        if ((goal == 2.0) && (pos > 50.0)) {
            pos = 0.0;
        }
        printf("%.2f\n",pos);
    } while (pos < goal);

    sm2.SetCRSpeed(0.0);
    
    wait (2.0);
    led2 = 0;
}


int main() {

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Snack-o-tron");
    lcd.locate(0,1);

    // set Servo to continusous rotation
    lcd.printf(" Init Motors");
    //sm1.SetMode(1);
    wait(0.5);

    lcd.locate(0,1);
    lcd.printf(" Done       ");
    wait(0.5);

    lcd.locate(0,1);
    lcd.printf(" Init Network");

    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        lcd.locate(0,1);
        lcd.printf("Network Error %d",ethErr);
        return -1;
    }

    // let the world know all is well!
    printf("Setup OK\n");
    lcd.locate(0,1);
    lcd.printf(" Done           ");
    wait (2.0);
    lcd.cls();

    HTTPText txt;

    while (1) {

        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Ready");

        led4 = 1; // this LED flashed with every HTTP request, for sanity
        HTTPResult r = http.get("http://example.com/snackcheck", &txt);

        if (r==HTTP_OK) {
            
            char sender[20];
            char snack[20];
            
            sscanf(txt.gets(),"%s\n%s\n",sender,snack);

            if ( (strcmp ("0",sender)) == 0) {
                printf("No snacks today\n");
            } else {

                printf("Sender : %s, Snack : %s\n", sender, snack);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("%s",sender);
                lcd.locate(0,1);
                lcd.printf("Snack %s",snack);

                // What to do if snack 1 is ordered
                if ( (strcmp ("1",snack)) == 0) {
                    DeliverSnack1();
                }
                // what to do if snack 2 is ordered
                else if ( (strcmp ("2",snack)) == 0) {
                    DeliverSnack2();
                }
            }

        } else {
            // HTTP error
            printf("Error %d\n", r);
        }

        // clear LEDs
        led4 = 0;
        wait (1.0);
    }
}
