#include "mbed.h"

DigitalOut myled(LED1);


SPI m_spi(p11, p12, p13);
DigitalOut m_cs(p14);
DigitalOut m_dc(p15);
DigitalOut m_tcs(p16);
DigitalOut m_rst(p23);
PwmOut m_led(p24);



const int m_height = 240;
const int m_width = 320;

void spiWrite(uint16_t data)
{
  m_cs = 0;
  m_spi.write(data);
  m_cs = 1;
}

bool m_drawMode = false;

void setRegAddr(uint16_t addr)
{
  m_dc = 0;
  spiWrite(addr);
}

void writeData(uint16_t data)
{
  m_dc = 1;
  spiWrite(data);
}

void point(uint16_t color)
{
  if(!m_drawMode)
  {
    setRegAddr(0x22);
    m_drawMode = true;
  }
  writeData(color);
}

void writeReg(uint16_t addr, uint16_t val)
{
  m_drawMode = false;
  setRegAddr(addr);
  
  writeData(val);
}

void setPos(uint16_t x, uint16_t y)
{
//  y = m_height - y;
  writeReg(0x4e, y & 0xFF);
  writeReg(0x4f, x & 0x1FF);
}

void setWindow(uint16_t startX, uint16_t startY, uint16_t endX, uint16_t endY)
{
//setPos( (startX + endX) / 2 ,  (startY + endY) / 2 );
  writeReg( 0x44, (startY & 0xFF) | (endY << 8) );
  writeReg( 0x45, startX & 0x1FF );
  writeReg( 0x46, endX & 0x1FF );
//  setPos( startX, startY );
//  setPos( startX ,  startY  );
//  setPos( startX +1,  startY+1 );
}

LocalFileSystem local("local"); 

void fillScreen(uint16_t color)
{
  setPos(0,0);
  for(int i = 0; i<m_height*m_width; i++)
    point(color);
}

void drawLine(int startX, int startY, int endX, int endY, uint16_t color, int width)
{
  float d = sqrt( (float) pow((endX - startX), 2.) + pow((endY - startY), 2.) );
  int x = startX;
  int y = startY;
  float cos_a = (float) (endX - startX) / d;
  float sin_a = (float) (endY - startY) / d;
  for(int i = 0; i < d; i++)
  {
    for(float j = -(float)width/2; j <= (float)width/2; j++)
    {
      x = ((float)i*cos_a) + startX - (float) j * sin_a;
      y = ((float)i*sin_a) + startY + (float) j * cos_a;
      setPos(x,y);
      point(color);
    }
  }
}

void drawLine2(int startX, int startY, int endX, int endY, uint16_t color, int w)
{
  //Top trapezis
  float d = sqrt( (float) pow((endX - startX), 2.) + pow((endY - startY), 2.) );
  float cos_a = (float) (endX - startX) / d;
  float sin_a = (float) (endY - startY) / d;
  float tan_a = (float) (endY - startY) / (endX - startX);


  int bY = endY + (float)(w*cos_a);
  int eY = endY - (float)(w*cos_a);
  for(int y = bY ; y > eY ; y-- )
  {
      int bX = endX - (float)(w*sin_a) - (float) (bY - y) / tan_a ;
      int eX = endX - (float)(w*sin_a) + (float) (bY - y) * tan_a ;
      setPos(bX,y);
      for(int x = bX; x <= eX; x++)
      {
        point(color);
       // wait(.1);
      }
  }
  

  //Main parralelogram
  int l = (float) (w / sin_a);
  
  bY = eY;
  eY = startY + (float)(w*cos_a);
  
  for( int y = bY ; y > eY ; y-- )
  {
    int bX = startX + (float)( (y - startY)/tan_a) - l;
    setPos(bX,y);
    for(int x = bX; x <= bX + l*2; x++)
    {
      point(color);
     // wait(.1);
    }
  }
  
}

#define ABS(a) (((a)>=0)?(a):-(a))

int main() {
    m_cs = 1;
    m_tcs = 1;
    m_spi.format(16);
    m_spi.frequency(20000000);
    
    //SPI_1
    //ssp_disable(LPC_SSP1);
    LPC_SC->PCLKSEL0 &= ~(3 << 20);
    LPC_SC->PCLKSEL0 |=  (1 << 20);
    LPC_SC->PCLKSEL0 &= ~(3 << 16);
    LPC_SC->PCLKSEL0 |=  (1 << 16);
    LPC_SC->PCLKSEL1 &= ~(3 << 10);
    LPC_SC->PCLKSEL1 |=  (1 << 10);   
    
    LPC_SSP1->CPSR = 2; //72 / 2 = 36MHz

    // A
    // divider
    LPC_SSP1->CR0 &= ~(0xFFFF << 8);
    LPC_SSP1->CR0 |= (1 - 1) << 8; //1 clock/bit
    LPC_SSP0->CR0 &= ~(0xFFFF << 8);
    LPC_SSP0->CR0 |= (1 - 1) << 8; //1 clock/bit
    //ssp_enable(LPC_SSP1); 
    
    m_led.period_us(2000);
    m_led.write(.3);
    
    m_rst = 0;
    wait_ms(1000);
    m_rst = 1;
    
    
    writeReg(0x07, 0x0021);
    writeReg(0x00, 0x0001);
    writeReg(0x07, 0x0723);
    writeReg(0x10, 0x0000);
    wait_ms(200);
    writeReg(0x07, 0x0033);
    //writeReg(0x11, 0x6830);
    writeReg(0x11, 0x6828);
    writeReg(0x02, 0x0600);
    writeReg(0x0f, 0x0000);
    writeReg(0x01, 0x2b3f);
    writeReg(0x0b, 0x5308);
    writeReg(0x25, 0xa000);
    
//    writeReg(0x01, 0x393f);
//    writeReg(0x11, 0x6030);
    
    wait(1);
  /*  uint16_t r;
    uint16_t g;
    uint16_t b;
    for(int i =0; i<0x20; i+=2)
    {
        //fgetc(fp);
      r = ABS(i-11);
      g = i*2;
      b = ABS(i-21);
      fillScreen((r << 11) | (g<<5) | b); //Blank
    }
    */
    
    fillScreen(0xFFFF);
   //wait(1);    
    

    FILE *fp = fopen("/local/mbed.bmp", "r"); 
    if(!fp)
    {
      error("!\n");
    }
    fseek(fp, 0xA, SEEK_SET);
    
    int offset = fgetc(fp);
    printf("offset = %d\n", offset);
    
    fseek(fp, offset, SEEK_SET);    
    uint16_t r;
    uint16_t g;
    uint16_t b;
    
    
    int px = 10;
    int w = 300;
    int py = 100;
    int h = 96;
    
    //writeReg(0x11, 0x6828);
    //setWindow( x, x + 40, y, y + 40 );
    
    
    
    for(int y = py; y < py + h; y++)
    {
        setPos(px, y);
      for(int x = px; x < px + w; x++)   
      {

//        setPos(x,y);
        b = fgetc(fp) >> 3;
        g = fgetc(fp) >> 2;
        r = fgetc(fp) >> 3;
        //fgetc(fp);
        point( (r << 11) | (g<<5) | b );
        //wait(.01);
      }
    }
    
    fclose(fp);
  
  wait (2.0);
    
    fillScreen(0xFFFF);
    
    for(float i = 25; i < 360*10; i++)
    {
      drawLine2( 160, 120, 160 + 100*cos((i/360)*3.14*2), 120 + 100*sin((i/360)*3.14*2), 0x0000, 2);
      wait_ms(10);
      drawLine2( 160, 120, 160 + 100*cos((i/360)*3.14*2), 120 + 100*sin((i/360)*3.14*2), 0xFFFF, 2);
    }

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
