/* mbed PCA9532 LED Driver Library - Hello World Example
 *
 * Copyright (c) 2010, cstyles (http://mbed.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "PCA9532.h"

PCA9532 leds (p28, p27, 0xc0);

int main() {

    // Set LED15 to blink
    leds.Period(1, 0.1);
    leds.Duty(1, 0.5);
    leds.SetLed(15, MODE_PWM1);

    // LED0-14 will fade up in turn
    while (1) {

        // 0x7FFF enables LED 0-14, which are being switched off
        leds.SetMode(0x7fff, MODE_OFF);

        // For each LED in turn
        for (int i = 0 ; i < 15 ; i++) {

            // Switch PWM to off, and connect LED(i)
            leds.Duty(0, 0.0);
            leds.SetLed(i, MODE_PWM0);

            // Fade LED(i) from 0 to 1.0
            for (float j = 0.0 ; j < 1.0 ; j+=0.01) {
                leds.Duty(0,j);
                wait(0.005);
            }

            // Set LED(i) to continuously ON
            // this stops it fading out and in again with LED(i+1)
            leds.SetLed(i, MODE_ON);
            wait (0.01);

        }

    } // while(1)
} // main

