#ifndef MAX7456_H
#define MAX7456_H
 
#include "mbed.h"
#include "Stream.h"


#define VM0 0x00
#define VM1 0x01
#define HOS 0x02
#define VOS 0x03
#define DMM 0x04
#define DMAH 0x05
#define DMAL 0x06
#define DMDI 0x07
#define CMM 0x08
#define CMAH 0x09
#define CMAL 0x0A
#define CMDI 0x0B
#define OSDM 0x0C
#define OSDBL 0x6C
#define STAT 0xA0

namespace mbed {

class MAX7456 : public Stream {
    
    // Public
    public:        
 
        MAX7456(PinName mosi, PinName miso, PinName clk, PinName ncs, PinName nrst, const char* name=NULL); 
  
        void cls (void);
        void locate (int x, int y);
        void vtrim (int v);
        void htrim (int h);
        void format (char c);
        int _getc(int character);   
    // Private
    private:

        SPI _spi;
        DigitalOut _ncs;    
        DigitalOut _nrst;  
        
        // register access functions
        int _read (int addrress);
        void _write (int address, int data);
    
        // putc method used by printf
        virtual int _putc(int c);
        virtual int _getc();
  
};

}

#endif
