/*
RotaryEncode
(c) 2009, cstyles
*/

#include "RotaryEncode.h"
#include "mbed.h"

/*
 Constructor, pin names for I2C and the I2C addrss of the device
 */


RotaryEncode::RotaryEncode(PinName A, PinName B) 
  : _rotary_in(A,B) {    

    _position = 0;
    
    // Attach ticker
    _ticker.attach(this, &RotaryEncode::_ticker_handler, 0.010);       
}



int RotaryEncode::read(void) {
   int rval = _position;
   _position = 0;
   return (rval);
}




void RotaryEncode::_ticker_handler(void) {

    _state = _rotary_in;
    _e = R_W;

    // we're in the no-change state
    if (_state == 0x03) {
        return;
    }

    while (_state != 0x03) {
    switch (_e) {
        case R_W:
            if (_state == 0x02)
                _e = R_R1;
            else if (_state == 0x01)
                _e = R_L1;
            break;

        case R_L1:
            if (_state == 0x00)
                _e = R_R2;
            break;
        case R_L2:
            if (_state == 0x01) {
                _e = R_R3;
                _position++;
            }
            break;
        case R_R1:
            if (_state == 0x00)
                _e = R_L2;
            break;
        case R_R2:
            if (_state == 0x02) {
                _e = R_L3;
                _position--;
            }
            break;
        }
    _state = _rotary_in;
    }
    
}




