/* PCA9532 
 * (c) 2009, cstyles
 */
 
#ifndef PCA9532_H
#define PCA9532_H

#include "mbed.h"

// register names
#define PCA9532_REG_INPUT0 0
#define PCA9532_REG_INPUT1 1
#define PCA9532_REG_PSC0 2
#define PCA9532_REG_PWM0 3
#define PCA9532_REG_PSC1 4
#define PCA9532_REG_PWM1 5
#define PCA9532_REG_LS0 6
#define PCA9532_REG_LS1 7
#define PCA9532_REG_LS2 8
#define PCA9532_REG_LS3 9

#define PCA9532_MODE_CLEAR 0
#define PCA9532_MODE_SET 1
#define PCA9532_MODE_PWM0 2
#define PCA9532_MODE_PWM1 3





class PCA9532 {

public:

    PCA9532(PinName sda, PinName scl, int addr);
          
    void write (int leds);
          
    void set (int leds);
    void clear (int leds);
    void pwm0 (int leds);
    void pwm1 (int leds);
    
    void duty0 (float d);
    void duty1 (float d);
    
    void period0 (float t);
    void period1 (float t);
        
protected:

    void _write(int reg, int data);
    int _read(int reg);

    void _rmw(int led, int mode);    
    
    int _addr;
    
    I2C _i2c;    

};


#endif
