/* mbed PCF9532 LED Driver Library
 *
 * Copyright (c) 2010, cstyles (http://mbed.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef PCA9532_H
#define PCA9532_H

#include "mbed.h"

// register names
#define PCA9532_REG_INPUT0 0
#define PCA9532_REG_INPUT1 1
#define PCA9532_REG_PSC0   2
#define PCA9532_REG_PWM0   3
#define PCA9532_REG_PSC1   4
#define PCA9532_REG_PWM1   5
#define PCA9532_REG_LS0    6
#define PCA9532_REG_LS1    7
#define PCA9532_REG_LS2    8
#define PCA9532_REG_LS3    9

// LED modes
#define MODE_OFF  0
#define MODE_ON   1
#define MODE_PWM0 2
#define MODE_PWM1 3

class PCA9532 {

public:

    PCA9532(PinName sda, PinName scl, int addr);

    int SetLed  (int led, int mode);
    int SetMode (int mask, int mode);
    int Duty (int channel, float duty);
    int Period (int channel, float period);

protected:

    void _write(int reg, int data);
    int _read(int reg);
    int _addr;
    I2C _i2c;

};


#endif
