// example to test out OLED on mbed + XPresso baseboard, sford

#include "mbed.h"
#include "EAOLED.h"

// NOTE: The xpresso board does not provide the data/command signal to the mbed, so I added a wire:
// Connect:
//  PIO2_7 of baseboard mbed socket (empty 2nd hole below mbed pin 21)
// to
//   PIO0_8(p13) of J6 (7th hole down on left side of J6)
// to provide OLED data/command signal

DigitalOut led(LED1);

EAOLED oled(p5, p6, p7, p8, p25); // mosi, dnc, sclk, cs, power
BusIn js(p13, p14, p22, p23); // down, right, left, up
DigitalIn push (p12);

int Cur_X = 48;
int Cur_Y = 32;
int Cur_Colour = 0xffffff; // white

void plot (int);

int main() {

    oled.cls();
    oled.printf("Hello World!");
    oled.locate(0,3);
    oled.printf("I'm an OLED!");
    wait(1);
    oled.cls();

    oled.pixel(Cur_X,Cur_Y,Cur_Colour);

    while (1) {        
        plot(js);
        wait (0.1);
    }
}


void plot (int dir) {

        // clear the screen
        if (push == 0) {
            oled.cls();
        }
        
        // if possible, move down
        else if (js == 0x7){ 
            if ( Cur_Y > 0) {
                Cur_Y--;
                oled.pixel(Cur_X,Cur_Y,Cur_Colour);
            }
        }

        // if possible, move right
        else if (js == 0xb){ 
            if (Cur_X > 0) {
                Cur_X--;
                oled.pixel(Cur_X,Cur_Y,Cur_Colour);
            }
        }

        // if possible, move left
        else if (js == 0xd){ 
            if (Cur_X < 96) {
                Cur_X++;
                oled.pixel(Cur_X,Cur_Y,Cur_Colour);
            }
        }
        
        // if possible, move up
        else if (js == 0xe){ 
            if (Cur_Y < 64) {
                Cur_Y++;
                oled.pixel(Cur_X,Cur_Y,Cur_Colour);
            }
        }
}
