#include "mbed.h"
#include "PCA9532.h"

DigitalOut myled(LED1);

PCA9532 leds (p28,p27,0xc0);

int main() {


// set leds 15-12 to PWM1 channel
leds.pwm1(0xf000);

// set leds 11-8 to PWM0 channel
leds.pwm0(0x0f00);

// set leds 7-4 to "off"
leds.clear(0x00f0);

// set leds 7-4 to "on"
leds.set(0xf);


while (1) {

    for (float i = 0.0 ; i < 1.0 ; i+=0.01) {
        leds.duty0(i);      // PWM0 brighter
        leds.duty1(1.0-i);  // PWM1 dimmer
        wait (0.01);
    }

    leds.clear(0xf);    // Toggle LEDS
    leds.set(0x00f0);

    for (float i = 1.0 ; i > 0.0 ; i-=0.01) {
        leds.duty0(i);      // PWM0 dimmer
        leds.duty1(1.0-i);  // PWM1 brighter

        wait (0.01);
    }

    leds.clear(0x00f0);    // Toggle LEDS
    leds.set(0x000f);


    
}

}

