#include "DemoBoard.h"

/*
 * This project used and ultrasonic range finder to blend and RGB LED from
 * green to yellow to red as the ranged object gets closer
 */

int main() {    

    while (1) {
    
        // Take a reading from the Ultrasonic Range Finder
        float d = srf;
        
        // Scale and trim the number so it approaches 0.0 at a long range
        // and approaches 1.0 as the range gets closer
        float normalised = (2.0/d) - 0.02;
        
        // Set the red component to get brighter the closer the range
        rgb.red(normalised);
        
        // Set the red component to get brighter the further the range
        rgb.green(1.0-normalised);

        // For completeness, print the measured range 
        pc.printf("Range is %.1f cm\n",(float)srf);
        wait (0.2);
  
    }

}


