#include "DemoBoard.h"

/*
 * This project uses an RFID tag reader and the USB interface as a HID keyboard
 * When an RFID tag is presented to the reader, it is "typed" to the host
 */

int main() {


  // Create a HTTPServer on default Port
  HTTPServer *http = new HTTPServer();

  // Register RPC in /rpc space
  http->addHandler(new HTTPRPC());

  // Register local filesystem to all places which are not in /rpc
  http->addHandler(new HTTPFileSystemHandler("/", "/local/"));

  // Register the HTTPServer on the Network device (will hopfully disappear in the next Version)
  http->bind();

  NetServer *net = NetServer::get();
  
  lcd.locate(0,1);
  lcd.printf("%hhu.%hhu.%hhu.%hhu\n", (net->getIPAddr().addr)&0xFF, (net->getIPAddr().addr>>8)&0xFF, (net->getIPAddr().addr>>16)&0xFF, (net->getIPAddr().addr>>24)&0xFF);

  while(1) {
      http->poll();
    }



}


