#include "DemoBoard.h"

/*
 * This project uses the LCD, the two pots, and the three buttons to make a simple
 * Etch-a-Sketch. Set the colour using the buttons, and use the pots to draw!
 * Oh yeah, more than 1.5 in any axis will clear the screen :-)
 */

int colour = 0x0;

// Functions to set the draw colour. Write this to the RGB LED
void RedRise() { colour = 0xff0000; rgb.write(colour);}
void GreenRise() { colour = 0x00ff00; rgb.write(colour);}
void BlueRise() { colour = 0x0000ff; rgb.write(colour);}

int main() {


    // Attach the colour set functions to
    // rising edge interrupt handlers
    RedButton.rise(&RedRise);
    GreenButton.rise(&GreenRise);
    BlueButton.rise(&BlueRise);

    // set the screen background to white
    lcd.fill(0,0,130,130,0xffffff);

    while(1) {
        // fetch the values from the pots, and scale them to 0-130
        int x = potx * 130;
        int y = poty * 130;
        
        // draw the pixel!
        lcd.pixel(x,y,colour);
        wait(0.01);
        
        // If any axis of the accelerometer read > 1.5g, clear the screen
        if ( (acc.x() > 1.5) || (acc.y() > 1.5) || (acc.x() > 1.5) ) {
           lcd.cls();
           lcd.fill(0,0,130,130,0xffffff);
        }
        
    }

}


