#include "mbed.h"

DigitalOut myled(LED1);

Serial pc (USBTX,USBRX);

SPI spi (p5,p6,p7);
DigitalOut cs (p8);

int main() {

    spi.format(8,2);

    // set initial state of CS pin
    cs = 0;
    wait (0.1);    
    
// start by clearing WP in Control register
// the RAM can not be accessed until WP is clear
    
    cs = 1;
    wait (0.1);    
    spi.write (0x8f); // write to control register
    spi.write(0x0); // clear all the bits
    cs = 0;
    
    wait (0.1);
    
// Now write to the RAM
    cs = 1;
    wait (0.1);    
    spi.write (0xA0); // write to first RAM location
    spi.write(0xa5);  // set a pattern
    cs = 0;

    wait (0.1);

// Now read from RAM
    cs = 1;
    wait (0.1);    
    spi.write (0x20); // read from first RAM location
    char data = spi.write(0x00); 
    cs = 0;


    printf("Read from location 0x20 and received 0x%X\n",data);


    while (1) {}

}
