#include "mbed.h"

LocalFileSystem fs ("fs");
DigitalOut led1(LED1);
DigitalOut led4(LED4);

int main() {

    int ctr=32; // 32 because the fixed size of the vector table
    
    printf("File patcher\n");

    FILE *f1 = fopen("/fs/file.unp","rb"); // read binary
    FILE *f2 = fopen("/fs/file.pat","wb"); // write binary

    if (f1 == NULL) {
        printf("Cant open file for reading\n");
        while (1) {
            led1 = !led1;
            wait(0.2);
        }
    }

    else {

        unsigned int vector [8]; // storage for the vector table
        unsigned int sum = 0;    //

        // read first 7 words (28 bytes) into an array
        for (int i = 0; i < 8; i++) {
            vector[i] = 0; // zero the vector location
            for (int j = 0; j < 4; j++) {
                char c = fgetc(f1);         // read char from file
                vector[i]  |= (c << (8*j)); // shift to byte location
            }
            sum += vector[i]; // keep a running total
        }


        // calculate the 2's compliment, for vector[7]
        vector[7] = (~sum) + 1;

        for (int i = 0; i < 8; i++) {
            printf("Vector[%d] = 0x%08x\n",i,vector[i]);
        }

        printf("Sum vector = 0x%08x\n",sum);


        // write out patched vector table
        // read first 7 words (28 bytes) into an array
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 4; j++) {
                char c = ( vector[i] >> (8*j)) & 0xFF;
                fputc(c,f2);         // read char from file
            }
        }

        // read in and write remaining bytes of source binary
        while (!feof(f1)) {
            char c = fgetc (f1);    // read char from file
            fputc(c,f2);            // write byte to file
            ctr++;
        }

    }

    fclose(f1);
    fclose(f2);

    printf("Done! %d bytes processed\n",ctr);
    while (1) {
        led4 = !led4;
        wait(0.2);
    }


}
