#include "mbed.h"

AnalogIn pot(p16);
DigitalOut led(LED1);

Serial pc(USBTX,USBRX);

Ticker tick;


float Vav=0.0;

void average (void) {
    led = !led;
    Vav = (Vav + pot)/2.0;
}


int main() {

    // run the ticker every 100ms
    tick.attach(&average,0.1);

    while (1) {
        pc.printf("Average is %.3f\n",Vav);
        wait (2.0);

    }
}
