#include "mbed.h"

#define NUM_SAMPLES 500000 // size of sample series
#define SAMPLE_BLOCKS 5

Timer t;

Serial pc(USBTX,USBRX);

AnalogIn ain(p17);

// initialise error counters
int num_4;
int num_8;
int num_16;
int num_32;
int num_64;
int num_128;
int num_256;
int num_512;
int num_1024;
int num_spike;

int main() {

    int num_samples = 0;

    num_4 = 0;
    num_8 = 0;
    num_16 = 0;
    num_32 = 0;
    num_64 = 0;
    num_128 = 0;
    num_256 = 0;
    num_512 = 0;
    num_1024 = 0;
    num_spike = 0;


// Take the average over 500,000 samples
// This is because the bias to 1.65v has a tolerance
    float AVERAGE = 0.5;

    pc.printf("Taking an average over %d samples\n",NUM_SAMPLES);
    while (num_samples < NUM_SAMPLES) {
        float r = ain.read();

        if ((r > 0.45) && (r < 0.55)) {
            AVERAGE += r;
            num_samples++;
        }
    }

    AVERAGE /= NUM_SAMPLES;

    num_samples = 0;
    pc.printf("Average = %f\n",AVERAGE);


// Now start sampling series of 500,000
// acculumating the errors seen in each range
    pc.printf("Profiling %d samples\n",SAMPLE_BLOCKS*NUM_SAMPLES);


    for (int j=0; j < SAMPLE_BLOCKS ; j++) {

        t.reset();
        t.start();

        for (int i = 0; i < NUM_SAMPLES ; i++) {
            float a = ain.read();


            if (a == 1.0) {
                num_spike++;    // > 2048 lsb
            } else if (a > (AVERAGE + 0.2500)) {
                num_1024++;    // > 1024 lsb
            } else if (a > (AVERAGE + 0.0625)) {
                num_512++;    // > 512 lsb
            } else if (a > (AVERAGE + 0.0312)) {
                num_256++;    // > 256 lsb
            } else if (a > (AVERAGE + 0.0312)) {
                num_128++;    // > 128 lsb
            } else if (a > (AVERAGE + 0.0156)) {
                num_64++;    // > 64 lsb
            } else if (a > (AVERAGE + 0.0078)) {
                num_32++;    // > 32 lsb
            } else if (a > (AVERAGE + 0.0039)) {
                num_16++;    // > 16 lsb
            } else if (a > (AVERAGE + 0.0019)) {
                num_8++;    // > 8 lsb
            } else if (a > (AVERAGE + 0.0009)) {
                num_4++;    // > 8 lsb
            }

            num_samples++;
        }
        t.stop();

        if (j==0) {
            pc.printf("Samples\t");
            pc.printf("4\t");
            pc.printf("8\t");
            pc.printf("16\t");
            pc.printf("32\t");
            pc.printf("64\t");
            pc.printf("128\t");
            pc.printf("256\t");
            pc.printf("512\t");
            pc.printf("1024\t");
            pc.printf("Spikes\t");
            pc.printf("Time\n");
        }


        // Every 500,000 print the results
        pc.printf("%d\t",num_samples);
        pc.printf("%d\t",num_4);
        pc.printf("%d\t",num_8);
        pc.printf("%d\t",num_16);
        pc.printf("%d\t",num_32);
        pc.printf("%d\t",num_64);
        pc.printf("%d\t",num_128);
        pc.printf("%d\t",num_256);
        pc.printf("%d\t",num_512);
        pc.printf("%d\t",num_1024);
        pc.printf("%d\t",num_spike);
        pc.printf("%fs\n",t.read());
    }

    pc.printf("==== Test Complete ====\n");
}
