#ifndef _ANDROIDADB_H_
#define _ANDROIDADB_H_

#include "mbed.h"
#include "Adb.h"
#include "defines.h"

#include <string>
#include <sstream>
#include <vector>
#include <iostream>
#include <stdlib.h>

/**
 * @author Arno Galliker
 *
 * @copyright Copyright (c) 2013 HSLU Pren Team #1 Cruising Crêpe
 * All rights reserved.
 *
 * @brief
 *
 * This File is for the connection to te self written java android app.
 * The connection works with the ADB class from rom Junichi Katsu.
 * For more information see here: <a href="http://mbed.org/users/jksoft/code/MicroBridge/">http://mbed.org/users/jksoft/code/MicroBridge/</a>
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /**
 * @file androidADB.h
 */

/**
* @brief Takes an string, a vector of strings for the delimited tokens. 
* Tokens is the array to separated with the delimiters.
* @param str to 
* @param tokens is the vecotr array
* @param delimiters of the string
*/
void Tokenize(const string& str,
              vector<string>& tokens,
              const string& delimiters = " ");

/**
* @brief Parse the Message, split and save it to the Attributes.
* @param length length of the data
* @param data Data to parse
*/
void parseMessage(uint16_t length, uint8_t * data);

/**
* @brief Connecting to android.
*/
void connect();

/**
* @brief Gets the desired &theta; value.
* @return the desired &theta;, given in [°]
*/
float getDesiredTheta();

/**
* @brief Gets the desired X-postition.
* @return the desired X-postition, given in [m]
*/
float getDesiredX();

/**
* @brief Gets the desired Y-postition.
* @return the desired Y-postition, given in [m]
*/
float getDesiredY();

/**
* @brief Sets the desired &theta; value.
* @param t desired &theta; value, given in [°]
*/
void setDesiredTheta(float t);

/**
* @brief Initialise the ADB subsystem. Open an ADB stream on tcp port 4568.
*/
void init();

/**
* @brief Write the Parameterlist to the android smartphone.
* @param x Acutal X-Position
* @param y Acutal Y-Position
* @param t Acutal &theta;-Position
* @param state_u Actual State Undervoltage
* @param state_l Actual Left State
* @param state_r Actual Right State
* @param volt_b Actual battery voltage
*/
void writeActualPosition(float x, float y, float t, int state_u, int state_l, int state_r, float volt_b);

#endif