
/** @file PacketBuffer.cpp
 * @brief Ring Buffer
 */

#include "PacketBuffer.h"


PacketBuffer::PacketBuffer(int num,int packet_size)
{
    max_num = num;
    max_size = packet_size;

    p_buf = new PacketBufInf[num];
        
    for(int i = 0 ; i < num ; i++)
    {
        p_buf[i].buf = new char[packet_size];
        p_buf[i].size = 0;
    }
    addr_w = 0;
    addr_r = 0;
}

PacketBuffer::~PacketBuffer()
{
    
    for(int i = 0 ; i < max_num ; i++)
    {
        delete [] p_buf[i].buf;
    }
    delete [] p_buf;
}

int PacketBuffer::PutPacket(char *packet, int len)
{
    int next;
    
    if(max_size < len) return(-1);
     
    next = (addr_w + 1) % max_num;
    
    if( next == addr_r ) return(0);
    
    memcpy( p_buf[addr_w].buf , packet , len );
    
    p_buf[addr_w].size = len;
    
    addr_w = next;
    
    return(len);
}

int PacketBuffer::GetPacket(char *packet)
{
    int len;
    
    if( addr_w == addr_r ) return(0);
    
    len = p_buf[addr_r].size;
    
    memcpy( packet , p_buf[addr_r].buf , len );
    
    addr_r = (addr_r + 1) % max_num;
    
    return len;
}

int PacketBuffer::available () {
    if (addr_w < addr_r) {
        return addr_r - addr_w - 1;
    } else {
        return (max_num - addr_w) + addr_r - 1;
    }
}

int PacketBuffer::use () {
    return max_num - available() - 1;
}

void PacketBuffer::clear () {
    addr_w = 0;
    addr_r = 0;
}
