#include "MaxonESCON.h"

using namespace std;

MaxonESCON::MaxonESCON(
    PinName enb,
    PinName isenb,
    PinName pwm,
    PinName actualSpeed,
    Hallsensor *hall
)
    :
    _enb(enb),
    _isenb(isenb),
    _pwm(pwm),
    _actualSpeed(actualSpeed),
    _hall(hall)
{

    _pwm = 0;

    // Initial condition of output enables
    _enb = 0;

    // Set initial condition of PWM 2kHz
    period(0.0005);

    // Set the pulses to zero
    _pulses = 0;

    // Set the Pull Up Resistor
    _isenb.mode(PullUp);
}

void MaxonESCON::setVelocity(float speed)
{
    speed = speed / ESCON_SET_FACTOR * 60.0f;
    if(speed > 1 ) {
        _pwm = 0.89f;
    } else if(speed < -1) {
        _pwm = 0.11f;
    } else {
        _pwm = 0.4f*speed + (0.5f * (SET_SPEED_PATCH));
    }
}

float MaxonESCON::getActualSpeed(void)
{
    return (_actualSpeed.read()* 2.0f - 1.0f *(GET_SPEED_PATCH)) * ESCON_GET_FACTOR / 60.0f;
}

void MaxonESCON::period(float period)
{
    _pwm.period(period);
}

void MaxonESCON::enable(bool enb)
{
    if(enb == true) {
        _enb = 1;
    } else {
        _enb = 0;
    }
}

bool MaxonESCON::isEnabled()
{
    if(_isenb.read() == 1) {
        return true;
    } else {
        return false;
    }
}

int MaxonESCON::getPulses(void)
{
    _pulses = _hall->getPulses();
    return _pulses;
}

int MaxonESCON::setPulses(int setPos)
{
    _hall->reset();
    _pulses = _hall->getPulses();
    return _pulses;
}
