#include "androidADB.h"

Connection * connection;

/** @brief Desired position in meters for x-coordinate, given by android */
float androidx;

/** @brief Desired position in meters for y-coordinate, given by android */
float androidy;

/** @brief Desired position in degrees for theta, given by android */
float androidt;

/** @brief Indicates if a ADB connection to a android phone is established */
boolean androidConnected;

float getDesiredX()
{
    return androidx/1000;
}

float getDesiredY()
{
    return androidy/1000;
}

float getDesiredTheta()
{
    return androidt * PI / 180;
}

void setDesiredTheta(float t)
{
    androidt = t;
}

void Tokenize(const string& str,
              vector<string>& tokens,
              const string& delimiters /*= " "*/)
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos) {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

extern void adbEventHandler(Connection * connection, adb_eventType event, uint16_t length, uint8_t * data)
{

    if (event == ADB_CONNECTION_OPEN) {
        androidConnected = true;
    } else if (event == ADB_CONNECTION_CLOSE) {
        androidConnected = false;
    }

    if (event == ADB_CONNECTION_RECEIVE) {
        parseMessage(length, data);

    }
}

void parseMessage(uint16_t length, uint8_t * data)
{
    char str[32];

    // convert buffer (unsigned char) to char
    sprintf( str, "%s", data);

    // new vector of strings
    vector<string> tokens;

    // tokenize the string with the semicolon separator
    Tokenize(str, tokens, ";");
    copy(tokens.begin(), tokens.end(), ostream_iterator<string>(cout, ", "));

    if(tokens.size() > 2) {

        //string to float
        androidx = ::atof(tokens.at(0).c_str());
        androidy = ::atof(tokens.at(1).c_str());
        androidt = ::atof(tokens.at(2).c_str());

    } else {}

}

void connect()
{
    ADB::poll();
    char c = 'c';
    connection->write(sizeof(c), (unsigned char*)&c);
}

void init()
{

    // Initialise the ADB subsystem.
    ADB::init();

    // Open an ADB stream on tcp port 4568. Auto-reconnect
    connection = ADB::addConnection("tcp:4568", true, adbEventHandler);

    // Connecting to android
    while(!(androidConnected)) {
        connect();
        wait(0.5);
    }

}

void writeActualPosition(float x, float y, float t, int state_u, int state_l, int state_r, float volt_b)
{
    // reconnect funktioniert trotzdem nicht!?
    while(!(androidConnected)) {
        connect();
        wait(0.5);
    }

    char str[100];

    //send to android
    sprintf( str, "%f;%f;%f;%i;%i;%i;%f;;", x,
             y,
             t * 180 / PI,
             state_u == 0 ? 0 : 1,
             state_l == 0 ? 0 : 1,
             state_r == 0 ? 0 : 1,
             volt_b);

    connection->write(sizeof(str),(unsigned char*)&str);

}