#include "Hallsensor.h"

Hallsensor::Hallsensor(
    PinName hall1,
    PinName hall2,
    PinName hall3
)
    : hall1_(hall1),
      hall2_(hall2),
      hall3_(hall3)
{
    pulses_       = 0;

    //Workout what the current state is.
    int h1 = hall1_.read();
    int h2 = hall2_.read();
    int h3 = hall3_.read();

    // Set the PullUp Resistor
    hall1_.mode(PullUp);
    hall2_.mode(PullUp);
    hall3_.mode(PullUp);

    //set interrupts on only hall 1-3 rise and fall.
    hall1_.rise(this, &Hallsensor::encode);
    hall1_.fall(this, &Hallsensor::encode);
    hall2_.rise(this, &Hallsensor::encode);
    hall2_.fall(this, &Hallsensor::encode);
    hall3_.rise(this, &Hallsensor::encode);
    hall3_.fall(this, &Hallsensor::encode);
}

void Hallsensor::reset(void)
{
    pulses_ = 0;
}

int Hallsensor::getPulses(void)
{
    return pulses_;
}


void Hallsensor::encode(void)
{
    // read the state
    int h1  = hall1_.read();
    int h2  = hall2_.read();
    int h3  = hall3_.read();

    //3-bit state.
    currState_ = (h1 << 2) | (h2 << 1) | h3;

    if ((prevState_ == 0x5) && (currState_ == 0x4)) {
        pulses_++;
        prevState_ = currState_;
        return;
    } else if (prevState_ == 0x5 && currState_ == 0x1) {
        pulses_--;
        prevState_ = currState_;
        return;
    }

    if ((prevState_ == 0x4) && (currState_ == 0x6)) {
        pulses_++;
        prevState_ = currState_;
        return;
    } else if (prevState_ == 0x4 && currState_ == 0x5) {
        pulses_--;
        prevState_ = currState_;
        return;
    }

    if ((prevState_ == 0x6) && (currState_ == 0x2)) {
        pulses_++;
        prevState_ = currState_;
        return;
    } else if (prevState_ == 0x6 && currState_ == 0x4) {
        pulses_--;
        prevState_ = currState_;
        return;
    }

    if ((prevState_ == 0x2) && (currState_ == 0x3)) {
        pulses_++;
        prevState_ = currState_;
        return;
    } else if (prevState_ == 0x2 && currState_ == 0x6) {
        pulses_--;
        prevState_ = currState_;
        return;
    }

    if ((prevState_ == 0x3) && (currState_ == 0x1)) {
        pulses_++;
        prevState_ = currState_;
        return;
    } else if (prevState_ == 0x3 && currState_ == 0x2) {
        pulses_--;
        prevState_ = currState_;
        return;
    }

    if ((prevState_ == 0x1) && (currState_ == 0x5)) {
        pulses_++;
        prevState_ = currState_;
        return;
    } else if (prevState_ == 0x1 && currState_ == 0x3) {
        pulses_--;
        prevState_ = currState_;
        return;
    }
    prevState_ = currState_;

}
