#ifndef _MOTION_STATE_H_
#define _MOTION_STATE_H_

#include "defines.h"

/**
 * @author Christian Burri
 *
 * @copyright Copyright (c) 2013 HSLU Pren Team #1 Cruising Crêpe
 * All rights reserved.
 *
 * @brief
 *
 * This help class is for calculate and save the actual or desired value.
 * There have the setter and the getter methode to change the value
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
class MotionState
{

public:

    /** @brief The xposition value of this motion state. */
    float xposition;
    /** @brief The yposition value of this motion state. */
    float yposition;
    /** @brief The &theta; of this motion state. */
    float theta;
    /** @brief The speed value of this motion state. */
    float speed;
    /** @brief The speed rotational value of this motion state. */
    float omega;

    /**
     * @brief Creates a <code>MotionState</code> object.
     * The values for position and speed are set to 0.
     */
    MotionState();

    /**
     * @brief Creates a <code>MotionState</code> object with given values for position and speed.
     * @param xposition the initial position value of this motion state, given in [m]
     * @param yposition the initial position value of this motion state, given in [m]
     * @param theta the initial &theta; value of this motion state, given in [rad]
     * @param speed the initial speed value of this motion state, given in [m/s]
     * @param omega the initial &omega; speed value of this motion state, given in [rad/s]
     */
    MotionState(float xposition,
                float yposition,
                float theta,
                float speed,
                float omega);

    /**
     * @brief Destructor of the Object to destroy the Object.
     */
    virtual     ~MotionState();

    /**
     * @brief Sets the values for xPosition, yPostion and &theta;.
     * @param xposition the initial position value of this motion state, given in [m]
     * @param yposition the initial position value of this motion state, given in [m]
     * @param theta the initial &theta; value of this motion state, given in [rad]
     * @param speed the initial speed value of this motion state, given in [m/s]
     * @param omega the initial &omega; speed value of this motion state, given in [rad/s]
     */
    void        setState(float xposition,
                         float yposition,
                         float theta,
                         float speed,
                         float omega);

    /**
     * @brief Sets the values for X-Position, Y-Postion and &theta;.
     * @param motionState another <code>MotionState</code> object to copy the state values from
     */
    void        setState(MotionState* motionState);

    /**
     * @brief Sets the X-position value.
     * @param xposition the desired xposition value of this motion state, given in [m]
     */
    void        setxPosition(float xposition);

    /**
     * @brief Gets the X-position value.
     * @return the xposition value of this motion state, given in [m]
     */
    float       getxPosition();

    /**
     * @brief Sets the Y-position value.
     * @param yposition the desired yposition value of this motion state, given in [m]
     */
    void        setyPosition(float yposition);

    /**
     * @brief Gets the Y-position value.
     * @return the xposition value of this motion state, given in [m]
     */
    float       getyPosition();

    /**
     * @brief Sets the &theta; value.
     * @param theta the desired &theta; value of this motion state, given in [rad]
     */
    void        setTheta(float theta);

    /**
     * @brief Gets the &theta; value.
     * @return the &theta; value of this motion state, given in [rad]
     */
    float       getTheta();

    /**
     * @brief Sets the speed value.
     * @param speed the desired speed value of this motion state, given in [m/s]
     */
    void        setSpeed(float speed);

    /**
     * @brief Gets the speed value.
     * @return the speed value of this motion state, given in [m/s]
     */
    float       getSpeed();

    /**
     * @brief Sets the &omega; value.
     * @param omega the desired &omega; value of this motion state, given in [rad/s]
     */
    void        setOmega(float omega);

    /**
     * @brief Gets the &omega; value.
     * @return the &omega; value of this motion state, given in [rad/s]
     */
    float       getOmega();

};

#endif
