/*
    Author: Christian Andresen
    Date: 13/01/2020
    
    Brief:
    Bootup screen for the STM32-756g_Discovery LCD monitor.
*/ 
#include "mbed.h" // Mbed header from mbed-os version 5
#include "stm32746g_discovery_lcd.h" // Last updated 27/11/2019
#include "bootup.h"

void bootup::LCD_Bootup()
{
    // Boot up LCD screen
    BSP_LCD_Init(); // Starts up the LCD
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    // Clear the screen, add black background and red text    
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *) "  Time: Day  ", RIGHT_MODE);
}