#include "mbed.h"
#include "23LCV1024.h"

SRAM23LCV1024::SRAM23LCV1024(SPI& spi, PinName cs) : _spi(spi), _cs(cs) {
    _cs = 1;    // Deselect the device so that it can initialize
}
    
int SRAM23LCV1024::getReadMode() {
    /* The mode bits indicate the operating mode of the SRAM:
        00 = Byte mode
        10 = Page mode
        01 = Sequential mode (default)
        11 = Reserved
    */
    
    _cs = 0;
    _spi.write(CMD_RDMR);
    int ram_mode =  _spi.write(0)>>6;
    _cs = 1;

    return ram_mode;
}
        
int SRAM23LCV1024::readBytes(int address, char* buffer, int length) {   
    int i;
 
    _cs = 0;
    _spi.write(CMD_READ);
    _spi.write((address >> 16) & 0xff);
    _spi.write((address >> 8) & 0xff);
    _spi.write(address & 0xff);
 
    for (i = 0; i < length; i ++) buffer[i] = _spi.write(0);

    _cs = 1;
    return 0;
}
        
        
int SRAM23LCV1024::writeBytes(int address, char* buffer, int length) {
    int i;
 
    _cs = 0;
    _spi.write(CMD_WRITE);
    _spi.write((address >> 16) & 0xff);
    _spi.write((address >> 8) & 0xff);
    _spi.write(address & 0xff);
 
    for (i = 0; i < length; i ++) _spi.write(buffer[i]);

    _cs = 1;
    return 0;
}
   