/*
 * SPI RAM 23LC1024 (Microchip)
 *   1Mbit
 */
#include "mbed.h"
#include "23LCV1024.h"
 
DigitalOut led1(LED1);
 
 //LPC1769
//Serial pc(USBTX, USBRX);
//SPI spi(p5, p6, p7); // mosi, miso, sclk

// LPC11U24
SPI spi(P0_9, P0_8, P1_29);
Serial pc(P0_19, P0_18);
 

 
int main() {
    pc.baud(115200);
    spi.frequency(16000000);

    led1 = 1;
    
    int i;
    char buf[256];
    
    printf("RAM write\r\n");
    SRAM23LCV1024 sram(spi, P0_2); // p8 for LPC1769
    
    printf("RAM mode: %d\n", sram.getReadMode());
     
    printf("Written Hello test\n");
    strcpy(buf, "Hello test!");
    sram.writeBytes(0x000000, buf, 11);

    for (i = 64; i < 125; i ++) buf[i-64] = i;

    sram.readBytes(0x000003, buf, 5);

    printf("reading bytes 3-5\n");
    
    for (i = 0; i < 5; i ++) {
        printf("%c", buf[i]);
    }
    printf("\n");
    
    led1 = 0;
    


}