
#include "button.h"

DigitalIn start_button(USER_BUTTON);
DigitalIn makihara_button(PD_2);
DigitalOut beep(PB_10);

DigitalIn phase1(PA_5);
DigitalIn phase2(PA_6);
DigitalIn phase4(PA_7);
DigitalIn phase8(PB_12);

DigitalIn teamSW(PC_11);
DigitalOut teamledblue(PC_10);
DigitalOut teamledred(PC_12);



int phaseSW(void){  
   phase1.mode(PullUp);
   phase2.mode(PullUp);
   phase4.mode(PullUp);
   phase8.mode(PullUp);    
   
   int SW=phase1+2*phase2+4*phase4+8*phase8;

   return SW;
}

  
int teamLED()
{
   teamSW.mode(PullUp);
   if(teamSW) {
       teamledblue=1;
       teamledred=0;
       return -1;
   } else {
       teamledblue=0;
       teamledred=1;
       return 1;
   }
}

void buzzer(bool on)
{
    if(on)
        beep = 1;
    else
        beep = 0;
}

bool start()
{
    if(start_button)
        return true;
    else
        return false;
}

void commandIn(int command[3])
{
   
   makihara_button.mode(PullUp);
   while(!makihara_button);
   for(int i=0; i < 3; ++i) {
       while(makihara_button);
       wait_ms(10);
       buzzer(1);
       while(!makihara_button);
       wait_ms(10);
       buzzer(0);
       command[i] = get_phase();
//        (*colors[i])(1);
    }
}

void initbutton()
{
   makihara_button.mode(PullUp);
   phase1.mode(PullUp);
   phase2.mode(PullUp);
   phase4.mode(PullUp);
   phase8.mode(PullUp);
}


int get_phase()
{
   return phase1 + phase2*2 + phase4*4 + phase8*8;
}